/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.mapping.tile.wall.Edge;
import technology.rocketjump.undermount.rendering.lighting.PointLightMesh;

public class PointLight {
    private final PointLightMesh mesh;
    private Vector2 worldPosition = new Vector2();
    public static float LIGHT_RADIUS = 7.0f;
    private Array<Edge> lightPolygonEdges = new Array();
    private Color color = Color.WHITE;

    public PointLight() {
        this.mesh = new PointLightMesh();
    }

    public PointLight(PointLightMesh pointLightMesh) {
        this.mesh = pointLightMesh;
    }

    public Vector2 getWorldPosition() {
        return this.worldPosition;
    }

    public void setWorldPosition(Vector2 worldPosition) {
        this.worldPosition = worldPosition;
    }

    public Array<Edge> getLightPolygonEdges() {
        return this.lightPolygonEdges;
    }

    public void setLightPolygonEdges(Array<Edge> lightPolygonEdges) {
        this.lightPolygonEdges = lightPolygonEdges;
    }

    public void updateMesh() {
        this.mesh.updateGeometry(this.worldPosition, LIGHT_RADIUS, this.lightPolygonEdges);
    }

    public void render(Camera camera, ShaderProgram lightShader) {
        this.mesh.render(camera, this.color, lightShader);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

